//plasmaflowerMod01.fsh
//https://glslsandbox.com/e#78126.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
uniform sampler2D iChannel0;

#ifdef GL_ES
precision mediump float;
#endif

uniform float time;
uniform vec2 mouse;
uniform vec2 resolution;

#define resolution u_WindowSize
#define time          u_Elapsed*0.31416
#define PI            3.141592654
#define mouse AUTO_MOUSE
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

const float pi = 3.14159;

// 2013-03-30 by @hintz

#define CGFloat float
#define M_PI 3.14159265359

vec3 hsvtorgb(float h, float s, float v)
{
	float c = v * s;
	h = mod((h * 6.0), 6.0);
	float x = c * (1.0 - abs(mod(h, 2.0) - 1.0));
	vec3 color;
 
	if (0.0 <= h && h < 1.0) 
	{
		color = vec3(c, x, 0.0);
	}
	else if (1.0 <= h && h < 2.0) 
	{
		color = vec3(x, c, 0.0);
	}
	else if (2.0 <= h && h < 3.0) 
	{
		color = vec3(0.0, c, x);
	}
	else if (3.0 <= h && h < 4.0) 
	{
		color = vec3(0.0, x, c);
	}
	else if (4.0 <= h && h < 5.0) 
	{
		color = vec3(x, 0.0, c);
	}
	else if (5.0 <= h && h < 6.0) 
	{
		color = vec3(c, 0.0, x);
	}
	else
	{
		color = vec3(0.0);
	}
 
	color += v - c;
 
	return color;
}

void main(void) 
{

	vec2 position = 0.5*(gl_FragCoord.xy - 0.5 * resolution) / resolution.y;
	float x = position.x;
	float y = position.y;
	
	CGFloat a = atan(x, y);
    
    	CGFloat d = sqrt(x*x+y*y);
    	CGFloat d0 = 0.5*(sin(d-time)+1.5)*d+0.02*time;
    	CGFloat d1 = 5.0; 
	
    	CGFloat u = mod(a*d1+sin(d*10.0+time), M_PI*2.0)/M_PI*0.5 - 0.5;
    	CGFloat v = mod(pow(d0*4.0, 0.75),1.0) - 0.5;
    
    	CGFloat dd = sqrt(u*u+v*v);
    
    	CGFloat aa = atan(u, v);
    
    	CGFloat uu = mod(aa*3.0+3.0*cos(dd*16.0-time), M_PI*2.0)/M_PI*0.5 - 0.5;
    	// CGFloat vv = mod(dd*4.0,1.0) - 0.5;
    
    	CGFloat d2 = sqrt(uu*uu+v*v)*1.5;
    
	gl_FragColor = vec4( hsvtorgb(dd+time*0.5/d1, dd, d2), 1.0 );
}